function [directions, lambda] = BTE_SIR(x,y,K)

% x the observed predictor matrix
% y the observed response vector
% K the dimension of central subspace
% This code is applicable when the response y is multivariate.
options.disp = 0;
[n,p] = size(x);
q = size(y,2);
x_orig = x;
x = x - ones(n,1) * mean(x);
Lambda = zeros(p,p,n);
for ii = 1: n
    clear address
    for kk = 1:q
        address(:, kk) =  (y(:,kk)   <  y(ii,kk));
    end
    unit = unique(address,'rows');
    for jj = 1: size(unit,1)
         temp =  x(diag((address - ones(n,1) * unit(jj,:)) *  (address - ones(n,1) * unit(jj,:))') == 0,:);
         if size(temp,1) == 1
             x_mean(jj,:) = zeros(1,p);
         else
             x_mean(jj,:) = mean(temp);
         end
         clear temp
    end
    x_mean(sum(x_mean.^2,2)==0,:) = [];
    Lambda(:, :, ii) = cov(x_mean);
end
[C, eig_value] = eigs(mean(Lambda,3), K, 'lm',options); %if K==p, use eig(full(A))
directions = (cov(x_orig))^(-1/2) * C;
lambda = eig(full(mean(Lambda,3)));
lambda = sort(lambda,'descend');

