load autompg.txt;
y=autompg(:,1);
x=autompg(:,2:8);

[n,p]=size(x);
x7=zeros(n,1);
loca=find(x(:,7)==1);x7(loca)=1;
x8=zeros(n,1);
loca=find(x(:,7)==2);x8(loca)=1;
x16=x(:,1:6);
x=[x16 x7 x8];
[n,p]=size(x);

muX = mean(x);
sigmaX = diag(cov(x));
x =(x-repmat(muX,n,1)) * diag(sigmaX)^(-0.5);
y=y-mean(y);

[directions, eigva] = BTE_SIR(x,y,1); % only the first egienvector;
% [directions, eigva] = BTE_SAVE(x,y,1);

lambda=eigva;

L = log(lambda+1) - lambda;
G = zeros(p,1);
for k=1:p
    G(k) = n / 2 * sum(L(1:k)) / sum(L) -n^(1/2) * k * (k+1) / p;
end
[maxG, K] = max(G),

alpha=inv(x'*x)*x'*y;
resi=y-x*alpha;

h=1.5*n^(-1/5);
directions=direct(x, y, h, 1); % MAVE;

alpha= directions;
index=x*alpha/norm(alpha); 

plot(index,resi,'.')
xlabel('Single-indexing direction')
ylabel('Residuals')


Tindex=(index*ones(1,n)-ones(n,1)*index')/h;
K=(15/16*(1-Tindex.^2).^2).*(abs(Tindex)<=1);
A=K.*(ones(n,1)*resi');
A1=sum(A,2)-diag(A);
A2=resi'*A1;
    
B=K.*K.*(ones(n,1)*resi.^2');
B1=sum(B,2)-diag(B);
B2=resi.^2'*B1;
 
Tfinal=A2/sqrt(2*B2),
Tfinal/(1+4*n^(-4/5)),
1-normcdf(Tfinal,0,1),